//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "MServerThread.h"
#include <dos.h>
#include "UpdateStatus.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------
//   Important: Methods and properties of objects in VCL can only be
//   used in a method called using Synchronize, for example:
//
//      Synchronize(UpdateCaption);
//
//   where UpdateCaption could look like:
//
//      void __fastcall UpdateStatus::UpdateCaption()
//      {
//        Form1->Caption = "Updated in a thread";
//      }
//---------------------------------------------------------------------------
#include "Server.h"
__fastcall UpdateStatus::UpdateStatus(bool CreateSuspended)
    : TThread(CreateSuspended)
{
}
//---------------------------------------------------------------------------

void __fastcall UpdateStatus::SetStatusBar(void)
{
  int c =  Form1->ServerSocket->Socket->ActiveConnections;
  int TotalWork = 0;
  for(int i = 0; i < c; i++)
  {
    TServerClientWinSocket* t =  (TServerClientWinSocket*) Form1->ServerSocket->Socket->Connections[i];
    //TServerClientThread* ct = Form1->ServerSocket->Socket->GetClientThread(t);
    TMServerThread* ct =   (TMServerThread*) Form1->ServerSocket->Socket->GetClientThread(t);
    TotalWork += ct->WorkDone;

  }

  if (c > 0)
    Form1->ProgressBar1->Position = (TotalWork / c);
  else
    Form1->ProgressBar1->Position = (0);

  Form1->ProgressBar1->Repaint();

}


void __fastcall UpdateStatus::Execute()
{

   Priority = tpLowest;

   while(!Terminated )
   {
     _sleep(1);

     int c =  Form1->ServerSocket->Socket->ActiveConnections;

    Form1->NumCC->Text = AnsiString::FloatToStrF(c,AnsiString::sffGeneral,5,1);

    SetStatusBar();

   } // end while not Terminated.

}
//---------------------------------------------------------------------------
